//+------------------------------------------------------------------+ 
//|                                                      XO.MQ4      |
//|                                                                  |
//| V1.   Original Author SHARIPOV AINUR                             |
//|       Conversion to MT4 and modification only adoleh2000         |
//| V2.   Completed by Tim Hyder 2008                                |
//|               a)   Added Audio, Visual and eMail alerts          | 
//|                                                                  |
//|   Copyright  2008, Tim Hyder aka Hiachiever                     |
//|                                                                  |
//|   PO BOX 768, Hillarys, Western Australia, Australia, 6923       |
//|                                                                  |
//|   GIFTS AND DONATIONS ACCEPTED                                   | 
//|   All my indicators should be considered donationware. That is   |
//|   you are free to use them for your personal use, and are        |
//|   under no obligation to pay for them. However, if you do find   |
//|   this or any of my other indicators help you with your trading  |
//|   then any Gift or Donation as a show of appreciation is         |
//|   gratefully accepted.                                           |
//|                                                                  |
//|   Gifts or Donations also keep me motivated in producing more    |
//|   great free indicators. :-)                                     |
//|                                                                  |
//|   PayPal - hiachiever@gmail.com                                  |  
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2007, Tim Hyder."
#property link      "http://www.the4xtrader.com"

#define vers    "11Feb.2008"
#define major   2
#define minor   0

#property indicator_separate_window
#property  indicator_buffers 2
#property  indicator_color1  Lime  //XO up
#property  indicator_color2  Red  //XO down

extern string NOTESETTINGS = " - - - INDICATOR SETTINGS - - - ";
extern double KirPER=5;//10
extern string NOTEALERTS = " - - - -  ALERTS  - - - - ";
extern bool CheckonBarClose = True;
extern bool StrongAlertsOnly = false;
extern bool MsgAlerts = true;
extern bool SoundAlerts = true;
extern string SoundAlertFile = "alert.wav";
extern bool eMailAlerts = false;

double cb,valuel,valueh,CurrentBar;
double Kir ,Hi, Lo, KirUp, KirDn,mode,cnt,cnt1,cur,kr,no;
double ExtMapBuffer1[]; // XO up
double ExtMapBuffer2[]; // Xo down
int loopbegin, LastTime;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
     IndicatorBuffers(2);   
//---- drawing settings
      
   SetIndexBuffer(0,ExtMapBuffer1);//bbMacd line
   SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID,3);//2
   
   
   SetIndexBuffer(1,ExtMapBuffer2);//Upperband line
   SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID,3);//2
   
  IndicatorShortName("XO ("+KirPER+"), "+valueh+","+valuel);
  SetIndexLabel(0,"XO Up");
  SetIndexLabel(1,"XO Down");
  LastTime = Time[0];


//---- indicators
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   string base, Msg, Subj;
   int limit, Bar;
   int counted_bars=IndicatorCounted();
   //---- check for possible errors
   if(counted_bars<0) return(-1);
   //---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
         
   loopbegin = Bars-1;
   for(int i = loopbegin; i >= 0; i--)
   {         

   if (Kir<1)
   {
      Hi=Close[i];
      Lo=Close[i];
      Kir=1;
   }

   cur=(Close[i]);

   if (cur > (Hi+KirPER * Point)) 
   {
      Kir=Kir+1;
      Hi=cur;
      Lo=cur-KirPER*Point;
      KirUp=1;
      KirDn=0;
      kr=kr+1;
      no=0;
   }

   if (cur < (Lo-KirPER*Point)) 
   {
      Lo=cur;
      Hi=cur+KirPER*Point;
      KirUp=0;
      KirDn=1;
      Kir=Kir+1;
      no=no+1;
      kr=0;
   }

   valueh=kr;
   ExtMapBuffer1[i]=valueh;//XO up

   if (valueh < 0) ExtMapBuffer1[i] = 0;
   if (valueh > 0) ExtMapBuffer1[i] = 1;

   valuel=0-no;
   ExtMapBuffer2[i]=valuel;// XO down

   if (valuel > 0) ExtMapBuffer2[i] = 0;

   if (valuel < 0) ExtMapBuffer2[i] = -1;
     
}

  Bar = 0;	
  if (CheckonBarClose) Bar = 1; 
  if (LastTime != Time[0])
  {
    base = Symbol()+ ", TF: " + TF2Str(Period());
    //-> UP
    if (ExtMapBuffer1[Bar] != 0 && ExtMapBuffer1[Bar+1] == 0)
    {
      Subj = base + ".  XO Up Trend Alert";
      Msg = Subj + " @ " + TimeToStr(TimeLocal(),TIME_SECONDS);
      DoAlerts(Msg,Subj);
      LastTime = Time[0]; 
    }

    //<- Down
    if (ExtMapBuffer2[Bar] != 0 && ExtMapBuffer2[Bar+1] == 0)
    {
      Subj = base + ".  XO Down Trend Alert";
      Msg = Subj + " @ " + TimeToStr(TimeLocal(),TIME_SECONDS);
      DoAlerts(Msg,Subj);
      LastTime = Time[0]; 
    }
  }

   
   
//----
   return(0);
  }
//+------------------------------------------------------------------+

void DoAlerts(string msgText,string eMailSub)
{
   if (MsgAlerts) Alert(msgText);
   if (SoundAlerts)  PlaySound(SoundAlertFile);
   if (eMailAlerts) SendMail(eMailSub, msgText);
}

string TF2Str(int period) 
{
  switch (period) 
  {
    case PERIOD_M1: return("M1");
    case PERIOD_M5: return("M5");
    case PERIOD_M15: return("M15");
    case PERIOD_M30: return("M30");
    case PERIOD_H1: return("H1");
    case PERIOD_H4: return("H4");
    case PERIOD_D1: return("D1");
    case PERIOD_W1: return("W1");
    case PERIOD_MN1: return("MN");
  }
  return (Period());
} 